package gov.va.med.mhv.bluebutton.service.impl;

import gov.va.med.mhv.bluebutton.HealthSummaryBusinessService;
import gov.va.med.mhv.bluebutton.webservice.HealthSummaryWebService;
import gov.va.med.mhv.common.api.exception.MHVException;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class HealthSummaryWebServiceImpl implements HealthSummaryWebService {
	private static final Log log = LogFactory.getLog(HealthSummaryWebServiceImpl.class);

	@Resource
	private HealthSummaryBusinessService healthSummaryBusinessService;
	
	/**
	 * REQUIRES A SESSION TOKEN FROM API
	 */
	@Override
	public Response getHealthSummaryDownload(String requestDate, String fileFormat, String ccdType) {
		
		Response ccda = null;
		//System.out.println("getHealthSummaryDownload called");
		try {

//			//TODO: acctActCreatorService.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, false, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VA_MEDICAL_IMAGES_AND_REPORT_REQUEST_PROCESSED, "details"));
//			
			ccda = healthSummaryBusinessService.getDocument(requestDate, fileFormat, ccdType);
		} catch (MHVException e1) {
			log.error(e1);
			//System.out.println(e1.getLocalizedMessage());
			
			//System.out.println(e1.getStackTrace().toString());
			//TODO: activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, false, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VA_MEDICAL_IMAGES_AND_REPORT_REQUEST_PROCESSED, "details"));
		}
		return ccda;
	}	
	
	

}
